#ifndef __CFPUInformation__
#define __CFPUInformation__

#include "../Basics/CString.hpp"
#include "SSystemInformation.hpp"
#include "../IO/CTextStream.hpp"

//	===========================================================================

using Exponent::Host::SSystemInformation;
using Exponent::Basics::CString;
using Exponent::IO::CTextStream;

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CFPUInformation CFPUInformation.hpp
		 * @brief Provides info about the host system FPU architecture
		 *
		 * @date 21/04/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CFPUInformation.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CFPUInformation
		{
		public:

//	===========================================================================

			/**
			 * Initialise the CPU information
			 */
			static void initialiseCPUInformation();

//	===========================================================================

			/**
			 * Dump all information to a text file
			 * @param path The path to write the data to
			 */
			static void dumpFPUInfoToFile(CSystemString &path);

			/**
			 * Output the system logs to the the supplied stream
			 * @param stream The text stream
			 */
			static void dumpFPUInfoToFile(CTextStream &stream);

//	===========================================================================

			/**
			 * Does the CPU have MMX
			 * @retval bool True if the CPU has MMX, false otherwise
			 */
			static bool CPUHasMMX() { return CFPU_INFORMATION_HAS_MMX; }

			/**
			 * Does the CPU have SSE
			 * @retval bool True if the CPU has SSE, false otherwise
			 */
			static bool CPUHasSSE() { return CFPU_INFORMATION_HAS_SSE; }

			/**
			 * Does the CPU have SSE2
			 * @retval bool True if the CPU has SSE2, false otherwise
			 */
			static bool CPUHasSSE2() { return CFPU_INFORMATION_HAS_SSE2; }

			/**
			 * Does the CPU have SSE3
			 * @retval bool True if the CPU has SSE3, false otherwise
			 */
			static bool CPUHasSSE3() { return CFPU_INFORMATION_HAS_SSE3; }

			/**
			 * Does the CPU have HT
			 * @retval bool True if the CPU has HT, false otherwise
			 */
			static bool CPUHasHyperThreading() { return CFPU_INFORMATION_HAS_HT; }

//	===========================================================================

		protected:

//	===========================================================================

			static bool CFPU_INFORMATION_HAS_MMX;		/**< Does the system support MMX */
            static bool CFPU_INFORMATION_HAS_SSE;		/**< Does the system support SSE  */
            static bool CFPU_INFORMATION_HAS_SSE2;		/**< Does the system support SSE2 */
            static bool CFPU_INFORMATION_HAS_SSE3;		/**< Does the system support SSE3 */
            static bool CFPU_INFORMATION_HAS_HT;		/**< Does the system support hyperthreading */

		};
	}
}
#endif	// End of CFPUInformation.hpp
